/**
 * @file    advance_software_protect_lib.h
 * @brief   ICWorkShop Universal MCU Anti-Debugger library
 * @author  csh@icworkshop.com iphone (+86) 15989373832
 *
 * Safety License Shield
 * Copyright (c) 2017-2024, ICWorkshop Limited, All Rights Reserved
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __advance_software_protect_lib_h
#define __advance_software_protect_lib_h
#ifdef __cplusplus
extern "C"
{
#endif

#include "./advance_software_protect_base.h"

	/* version */
	extern const char *advance_software_protect_version(void);
	/* get system status */
	extern bool advance_software_protect_system_status_get(advance_software_protect_status *status);

	/* utils */
	extern void advance_software_protect_dump_buf(const char *title, unsigned char *buf, size_t len);
	extern int advance_software_protect_random(unsigned char *buf, size_t len);
	extern void advance_software_protect_set_last_error(E_ADV_SOFTWARE_PROTECT_ERROR_CODE err);
	extern E_ADV_SOFTWARE_PROTECT_ERROR_CODE advance_software_protect_get_last_error(void);
	extern uint32_t crc32_inner(const void *data, int nBytes);
	extern uint32_t crc32_continue_inner(uint32_t prev_crc, const void *data, int nBytes);

	/* porting */
	extern void advance_software_protect_system_reset(void);

	/* set callbacks */
	extern bool advance_software_protect_set_logger_callback(const advance_software_logger_callback cb);
	extern bool advance_software_protect_set_mem_calloc_free_callback(calloc_func_cb calloc_func, free_func_cb free_func);

	/* digital signature verification */
	extern bool advance_software_protect_verify_authorization(const E_ADV_SOFTWARE_PROTECT_SIGNATURE *config);

	/* object watcher  */
	extern bool __advance_software_protect_objectwatch_check(void *object_ptr, size_t info_in_object);
#define advance_software_protect_objectwatch_check(object, type) __advance_software_protect_objectwatch_check(object, offsetof(type, m_info))
	extern void __advance_software_protect_objectwatch_update(void *object_ptr, size_t info_in_object);
#define advance_software_protect_objectwatch_update(object, type) __advance_software_protect_objectwatch_update(object, offsetof(type, m_info))

	extern void advance_software_protect_objectwatch_list_set_callback(ObjectWatcherCallback eventCallback);
	extern bool advance_software_protect_objectwatch_list_find(void *object_ptr);
	extern bool advance_software_protect_objectwatch_list_add(void *object_ptr, size_t object_size, bool del_object_when_remove);
	extern size_t advance_software_protect_objectwatch_list_size(void);
	extern bool advance_software_protect_objectwatch_list_remove(void *object_ptr);
	extern void advance_software_protect_objectwatch_list_reset(void);
	extern bool advance_software_protect_objectwatch_list_check(void *object_ptr);
	extern size_t advance_software_protect_objectwatch_list_check_all(void);
	extern bool advance_software_protect_objectwatch_list_update(void *object_ptr);
	extern void advance_software_protect_objectwatch_list_update_all(void);

	/* code encryption */
	extern void advance_software_protect_encryption_code_loader(uint32_t load_address, uint64_t key, CodeLoaderCallback callback);

	/* flash verify */
	extern E_ADV_SOFTWARE_PROTECT_FLASH_VERIFY_RESULT advance_software_protect_flash_verify(uint64_t key);

	/* anti - debugger */
	extern bool advance_software_protect_anti_debugger(AntiDebuggerCallback eventCallback);

#ifdef __cplusplus
}
#endif
#endif
