/*!
    \file  cortex_chipid_binding.h
    \brief CMSIS Cortex Device Peripheral Access Layer Header File for
           Most of the Cortex Device
*/

/* Copyright (c) 2019 ICWorkShop LTD

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ICWorkShop nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE.
   ---------------------------------------------------------------------------*/
	 
/* Define to prevent recursive inclusion -------------------------------------*/

#ifndef CORTEX_CHIPID_BINDING_H
#define CORTEX_CHIPID_BINDING_H

#ifdef __cplusplus
extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
#include <string.h>
#include <stdint.h>
#include <stdbool.h>
#include "sissdk_ecdsa.h"
	
/* Exported define --------------------------------------------------------*/
/* The following parameter definitions must be consistent with the actual chip and burner settings */

#define    UID_CHIP_MASK                0x852F608B              //Random generation
#define    UID_CHIP_SIZE                12                      //ChipID Size							       //ChipID Size
#define    UID_CHIP_ADDR                (0x1FFFF7E8^UID_CHIP_MASK) //ChipID Inner Addr in chip

#define    LICENCE_ADDR                 (0x0800FF80^UID_CHIP_MASK)  //Licence Store Addr In flash		

/*
	Warning:	
	If you define placeholders at the tail of the store, you may fail to compile 
	because the compiler will automatically add some more information at the tail, 
	which may cause the ROM range to be exceeded:"Load region LR_IROM1 size(xxxx) exceeds limit(xxxx)",
	At this time, you need to make the address of the placeholder smaller
*/	
#define    UID_LICENCEADDR_PLACEHOLDER_EN   1                    //Licnece Store Addr In Flash Enable/Disable Placeholder

#if UID_LICENCEADDR_PLACEHOLDER_EN
 #define    UID_ENABLE_TAG               1                        //when = 1,Addr in flash at LICENCE_ADDR has tag value when complied project
 #define    UID_KEY_TAG                  0x5AA5A55A               //Key Tag in flash
#endif

/* Exported struct enum -----------------------------------------------------*/



/* Exported functions --------------------------------------------------------*/

/* UID Function pointer type */
typedef bool (*ChipUIDAlgo_Typedef)(const uint8_t pChipID[],const uint16_t chipIdSize,const S_ECDSA_SIGN * licence);

/**
  * @brief  Initialization chip ID. Called at initialization time
  * Note:   Please do not place ChipUIDAlgo_Calc in the same place as ChipUIDAlgo_Check
  * @retval void
  */																		 
void ChipUIDInitial(void);
/**
  * @brief  Calculate the key
  * Note:   Before calling. Must have called ChipUIDInitial      
  * @retval pKey
  */
																		 
bool ChipUIDAlgo_Calc(void);

/**
  * @brief  Check the key
  * Note:   Before calling. Must have called ChipUIDInitial      
  * @retval if key is same then retun true,Otherwise, return false
  */
bool ChipUIDAlgo_Check(void);


#ifdef __cplusplus
}
#endif

#endif /* CORTEX_CHIPID_BINDING_H */
