/*!
    \file  cortex_chipid_binding.c
    \brief CMSIS Cortex Device Peripheral Access Layer Header File for
           Most of the Cortex Device
*/

/* Copyright (c) 2019 ICWorkShop LTD

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ICWorkShop nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE.
   ---------------------------------------------------------------------------*/
	 
/* Includes ------------------------------------------------------------------*/
#include "cortex_chipid_binding.h"

/**
  * @brief  Password calculation matrix
  * @note   Need to compile into the project. For verification. 
	*         Please keep the burner and project consistent
  * @retval None
  */


#define	ENABLE_JUNK_CODE	1	//Enable/Disable junk code 

#if ENABLE_JUNK_CODE
static char mJunkCodeVar[UID_KEY_LENGTH];	//junkCode for mix

//The following code may warn in KEIL(MDK), ignore it
static void ChipUIDAlgo(char pUserID[], char pChipID[], char pKey[])
{
	pKey[0] = pUserID[0] - pChipID[7] & pChipID[5] ^ pChipID[3] ;
	mJunkCodeVar[4] = pUserID[6] * pChipID[10] ^ mJunkCodeVar[0] + pKey[8] ;//junk code,Your can remove or add your's junk code
	pKey[1] = pUserID[11] * pChipID[11] | pChipID[0] + pUserID[6] ;
	mJunkCodeVar[5] = pChipID[10] * pUserID[9] ^ mJunkCodeVar[8] ^ pChipID[7] ;//junk code,Your can remove or add your's junk code
	pKey[2] = pChipID[6] * pChipID[8] + pChipID[1] ^ pChipID[4] ;
	mJunkCodeVar[7] = pKey[9] ^ pChipID[7] ^ pKey[9] | pUserID[9] ;//junk code,Your can remove or add your's junk code
	mJunkCodeVar[4] = mJunkCodeVar[9] | pChipID[1] * pChipID[6] | pKey[6] ;//junk code,Your can remove or add your's junk code
	mJunkCodeVar[6] = pKey[9] | pKey[3] & pChipID[7] - pChipID[5] ;//junk code,Your can remove or add your's junk code
	pKey[3] = pUserID[5] | pChipID[9] & pUserID[1] - pUserID[8] ;
	mJunkCodeVar[11] = pChipID[7] | mJunkCodeVar[0] - pChipID[5] | pUserID[8] ;//junk code,Your can remove or add your's junk code
	mJunkCodeVar[4] = pChipID[4] * pKey[3] - pKey[0] & pUserID[8] ;//junk code,Your can remove or add your's junk code
	mJunkCodeVar[6] = mJunkCodeVar[10] - pChipID[1] & mJunkCodeVar[2] - pUserID[5] ;//junk code,Your can remove or add your's junk code
	pKey[4] = pUserID[4] * pUserID[10] ^ pUserID[3] | pUserID[2] ;
	pKey[5] = pUserID[7] & pChipID[2] + pUserID[9] - pChipID[10] ;
	mJunkCodeVar[8] = pUserID[2] - mJunkCodeVar[5] * pKey[1] ^ pUserID[3] ;//junk code,Your can remove or add your's junk code
	pKey[6] = pUserID[9] ^ pChipID[1] - pUserID[0] | pUserID[11] ;
	mJunkCodeVar[8] = pUserID[2] & pChipID[11] * pKey[5] & pKey[7] ;//junk code,Your can remove or add your's junk code
	mJunkCodeVar[11] = pKey[0] + pKey[6] | pChipID[3] + pUserID[6] ;//junk code,Your can remove or add your's junk code
	mJunkCodeVar[6] = pKey[10] + pChipID[11] + pChipID[1] * pUserID[7] ;//junk code,Your can remove or add your's junk code
	pKey[7] = pUserID[8] * pUserID[10] + pUserID[4] & pUserID[6] ;
	mJunkCodeVar[11] = pUserID[6] * pChipID[8] - mJunkCodeVar[11] | pUserID[5] ;//junk code,Your can remove or add your's junk code
	mJunkCodeVar[5] = pChipID[5] + pChipID[9] & pKey[7] ^ pKey[8] ;//junk code,Your can remove or add your's junk code
	pKey[8] = pChipID[6] | pUserID[2] & pChipID[11] + pUserID[7] ;
	mJunkCodeVar[1] = mJunkCodeVar[7] | pChipID[3] & mJunkCodeVar[8] * mJunkCodeVar[3] ;//junk code,Your can remove or add your's junk code
	mJunkCodeVar[4] = pUserID[2] + pKey[2] + pUserID[10] & pKey[8] ;//junk code,Your can remove or add your's junk code
	mJunkCodeVar[5] = pKey[11] + pChipID[5] + pUserID[10] | mJunkCodeVar[10] ;//junk code,Your can remove or add your's junk code
	pKey[9] = pUserID[3] - pChipID[5] * pChipID[4] ^ pUserID[5] ;
	mJunkCodeVar[7] = pUserID[5] + pUserID[4] | mJunkCodeVar[5] * pKey[3] ;//junk code,Your can remove or add your's junk code
	mJunkCodeVar[4] = pKey[6] & pKey[9] & pKey[0] - pUserID[4] ;//junk code,Your can remove or add your's junk code
	pKey[10] = pChipID[8] - pUserID[1] | pChipID[10] & pChipID[3] ;
	mJunkCodeVar[0] = pKey[1] | pKey[4] & mJunkCodeVar[10] + pChipID[3] ;//junk code,Your can remove or add your's junk code
	mJunkCodeVar[11] = pChipID[3] & mJunkCodeVar[9] ^ mJunkCodeVar[3] - mJunkCodeVar[6] ;//junk code,Your can remove or add your's junk code
	mJunkCodeVar[1] = mJunkCodeVar[10] ^ pKey[4] ^ pChipID[1] | pChipID[7] ;//junk code,Your can remove or add your's junk code
	pKey[11] = pChipID[2] * pChipID[7] ^ pChipID[9] + pChipID[0] ;
	mJunkCodeVar[0] = pKey[1] - mJunkCodeVar[1] + mJunkCodeVar[10] + pChipID[9] ;//junk code,Your can remove or add your's junk code
	mJunkCodeVar[5] = mJunkCodeVar[5] + pChipID[3] - pChipID[2] * mJunkCodeVar[3] ;//junk code,Your can remove or add your's junk code
}

#else
//The following code may warn in KEIL(MDK), ignore it
static void ChipUIDAlgo(char pUserID[], char pChipID[], char pKey[])
{
	pKey[0] = pUserID[0] - pChipID[7] & pChipID[5] ^ pChipID[3] ;
	pKey[1] = pUserID[11] * pChipID[11] | pChipID[0] + pUserID[6] ;
	pKey[2] = pChipID[6] * pChipID[8] + pChipID[1] ^ pChipID[4] ;
	pKey[3] = pUserID[5] | pChipID[9] & pUserID[1] - pUserID[8] ;
	pKey[4] = pUserID[4] * pUserID[10] ^ pUserID[3] | pUserID[2] ;
	pKey[5] = pUserID[7] & pChipID[2] + pUserID[9] - pChipID[10] ;
	pKey[6] = pUserID[9] ^ pChipID[1] - pUserID[0] | pUserID[11] ;
	pKey[7] = pUserID[8] * pUserID[10] + pUserID[4] & pUserID[6] ;
	pKey[8] = pChipID[6] | pUserID[2] & pChipID[11] + pUserID[7] ;
	pKey[9] = pUserID[3] - pChipID[5] * pChipID[4] ^ pUserID[5] ;
	pKey[10] = pChipID[8] - pUserID[1] | pChipID[10] & pChipID[3] ;
	pKey[11] = pChipID[2] * pChipID[7] ^ pChipID[9] + pChipID[0] ;
}

#endif


/**
  * @brief  Data Endian Swap in uint32
  * @note   Please keep the burner and project consistent, do not modify it
  * @retval None
  */

void U32DataEndiaSwap(uint32_t * pBuffer, uint32_t size)
{
    int i;
    for(i = 0; i < size; i ++){
        pBuffer[i] = BigLittleSwap32(pBuffer[i]);
    }
}  

/* store full chipID */
static char mChipID[UID_CHIP_SIZE];

/* initial chip id */
static uint32_t mChipAddr;					//global 

/* calc key compare with  mKey */
static char mCalcKey[UID_KEY_LENGTH];	 


/* store full userID */
static char mUserID[] = {
#if (UID_USERID_LENGTH == 4)
	(UID_USERID_KEY1 & 0xff),((UID_USERID_KEY1>>8) & 0xff),((UID_USERID_KEY1>>16) & 0xff),((UID_USERID_KEY1>>24) & 0xff),
#elif (UID_USERID_LENGTH == 8)
	(UID_USERID_KEY1 & 0xff),((UID_USERID_KEY1>>8) & 0xff),((UID_USERID_KEY1>>16) & 0xff),((UID_USERID_KEY1>>24) & 0xff),
	(UID_USERID_KEY2 & 0xff),((UID_USERID_KEY2>>8) & 0xff),((UID_USERID_KEY2>>16) & 0xff),((UID_USERID_KEY2>>24) & 0xff)	
#else
	(UID_USERID_KEY1 & 0xff),((UID_USERID_KEY1>>8) & 0xff),((UID_USERID_KEY1>>16) & 0xff),((UID_USERID_KEY1>>24) & 0xff),
	(UID_USERID_KEY2 & 0xff),((UID_USERID_KEY2>>8) & 0xff),((UID_USERID_KEY2>>16) & 0xff),((UID_USERID_KEY2>>24) & 0xff),
	(UID_USERID_KEY3 & 0xff),((UID_USERID_KEY3>>8) & 0xff),((UID_USERID_KEY3>>16) & 0xff),((UID_USERID_KEY3>>24) & 0xff)
#endif
};

/* Store the key calculated by the burner	*/
#if UID_KEYADDR_PLACEHOLDER_EN
const static char mKey[UID_KEY_LENGTH] __attribute__((section(UID_KEYADDR_INNER)))
#if UID_ENABLE_TAG
= 
{

	#if (UID_KEY_LENGTH == 4)
		UID_KEY_TAG & 0xff,(UID_KEY_TAG >> 8) & 0xff,(UID_KEY_TAG >> 16) & 0xff,(UID_KEY_TAG >> 24) & 0xff
	#elif (UID_KEY_LENGTH == 8)
			UID_KEY_TAG & 0xff,(UID_KEY_TAG >> 8) & 0xff,(UID_KEY_TAG >> 16) & 0xff,(UID_KEY_TAG >> 24) & 0xff,
			UID_KEY_TAG & 0xff,(UID_KEY_TAG >> 8) & 0xff,(UID_KEY_TAG >> 16) & 0xff,(UID_KEY_TAG >> 24) & 0xff
	#else
			UID_KEY_TAG & 0xff,(UID_KEY_TAG >> 8) & 0xff,(UID_KEY_TAG >> 16) & 0xff,(UID_KEY_TAG >> 24) & 0xff,
			UID_KEY_TAG & 0xff,(UID_KEY_TAG >> 8) & 0xff,(UID_KEY_TAG >> 16) & 0xff,(UID_KEY_TAG >> 24) & 0xff,
			UID_KEY_TAG & 0xff,(UID_KEY_TAG >> 8) & 0xff,(UID_KEY_TAG >> 16) & 0xff,(UID_KEY_TAG >> 24) & 0xff
	#endif

}
#endif
;	
#else
	//no license placeholder
#endif


/**
  * @brief  Initialization chip ID. Called at initialization time
  * Note:   Please do not place ChipUIDAlgo_Calc in the same place as ChipUIDAlgo_Check
  * @retval void
  */
void ChipUIDInitial()
{
    //restore real id Addr
    int i = 0;
		
		uint32_t chipIDAddr = 0;
    uint32_t mask = 0x0000000f;
	
    mChipAddr = UID_CHIP_ADDR;
    mChipAddr ^= UID_CHIP_ADDR_MIX;

    //Do not read directly from the address,you could use your's style
    
		for ( i = 0; i < sizeof(uint32_t) * 2; i++)
    {
        chipIDAddr |= mChipAddr & (mask << i * 4);
    }
    //If it has been modified by decompiling, exit
    if (chipIDAddr == 0 || chipIDAddr == 0xffffffff)
        return;
        //copy to array
#if ((defined STM32L1_Series) || (defined STM32L0_Series)) //offset 0x00,0x04,0x14
    for (i = 0; i < UID_CHIP_SIZE; i++)
    {
        mChipID[i] = *(uint8_t *)chipIDAddr;
        if (i != 7)
        {
            chipIDAddr++;
        }
        else
        {
            chipIDAddr += 0x0D;
        }
    }
#else
    for (i = 0; i < UID_CHIP_SIZE; i++)
    {
        mChipID[i] = *(uint8_t *)chipIDAddr;
        chipIDAddr++;
    }
#endif
}


/**
  * @brief  Calculate the key
  * Note:   Before calling. Must have called ChipUIDInitial      
  * @retval pKey
  */

char * ChipUIDAlgo_Calc()
{
  ChipUIDAlgo_Typedef func = ChipUIDAlgo;
	(*func)(mUserID,mChipID,mCalcKey);
	if(UID_DATAENDIAN == bigEndian){
		U32DataEndiaSwap((uint32_t *)mCalcKey, sizeof(mCalcKey)/ sizeof(uint32_t));
	}
	return mCalcKey;
}

/**
  * @brief  Check the key
  * Note:   Before calling. Must have called ChipUIDInitial      
  * @retval if key is same then retun true,Otherwise, return false
  */

bool __inline ChipUIDAlgo_Check()
{
		const char *mLicAddr = 0;
    int mLicAddrI32 = 0;
	
		ChipUIDAlgo_Calc();

    mLicAddrI32 = UID_KEYADDR_INNER_MIXED;
    mLicAddrI32 ^= UID_KEYADDR_MIX;
    mLicAddr = (char *)(mLicAddrI32);

    return 0 == memcmp(mCalcKey, mLicAddr, UID_KEY_LENGTH);
}





