/*!
    \file  cortex_chipid_binding.h
    \brief CMSIS Cortex Device Peripheral Access Layer Header File for
           Most of the Cortex Device
*/

/* Copyright (c) 2019 ICWorkShop LTD

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ICWorkShop nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE.
   ---------------------------------------------------------------------------*/
	 
/* Define to prevent recursive inclusion -------------------------------------*/

#ifndef CORTEX_CHIPID_BINDING_H
#define CORTEX_CHIPID_BINDING_H

#ifdef __cplusplus
extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
#include <string.h>
#include <stdint.h>
#include <stdbool.h>

/* Exported define --------------------------------------------------------*/

#define	STM32F2_Series

#ifndef STM32F205xC
	#define STM32F205xC
#endif

/* The following macros are automatically exported by the software supporting the burner. 
   Please do not modify them to keep them consistent */

#define    UID_CHIP_SIZE                12								       //ChipID Size
#define	   UID_CHIP_ADDR_MIX            0x0E027652               //ChipID Inner Addr MIX in chip
#define    UID_CHIP_ADDR                0x11FD0C42               //ChipID Inner Addr in chip

#define    UID_ENABLE_TAG               1                        //when = 1,Addr in flash at UID_KEYADDR_INNER has tag value when complied project
#define    UID_KEY_TAG                  0x5AA5A55A               //Key Tag in flash
#define    UID_KEY_LENGTH               12                       //The password is the same length as the user ID input
#define    UID_KEYADDR_INNER            ".ARM.__at_0x08002000"   //Key Store Addr In flash	

/***********************************Important Notice****************************/
/*
 *	Enabling placeholders to force the definition to the specified address can 
 *prevent conflicts, but may lead to compiled code out of space, therefore, if 
 *the signature address is in the firmware, be sure to turn on the placeholders,
 *if the signature address is outside the firmware, there is no need to turn on 
 *the PowerWriter based on the current chip's capacity address to make a judgement,
 *if the signature address > 0.7 * the chip's capacity, then no If the signature 
 *address is > 0.7 * chip capacity, then no placeholder will be enabled, if it is 
 *less than 0.7 * chip capacity, then placeholder will be enabled, developers 
 *can adjust according to their own needs. 
 */
	
#define    UID_KEYADDR_PLACEHOLDER_EN   1                        //Key Store Addr In Flash Enable/Disable Placeholder
/*******************************************************************************/

#define    UID_KEYADDR_MIX              0x10E3691B               //Key Store Addr In Flash Mix Rand
																																 //Key Store Addr In Flash Mixed
#define    UID_KEYADDR_INNER_MIXED      (0x08002000 ^ UID_KEYADDR_MIX)    

#define    UID_USERID_LENGTH            UID_KEY_LENGTH           //Customize password length
#define    UID_USERID_KEY1              0x1FCE5E67               //UserID 1
#define    UID_USERID_KEY2              0x71B4FB20               //UserID 2
#define    UID_USERID_KEY3              0x386CBCFF               //UserID 3

#define 	 UID_DATAENDIAN               littleEndian             //Data Endian
/* Exported struct enum -----------------------------------------------------*/

/* Data endian define */
#ifndef E_DataEndian
typedef enum E_DataEndian
{
    littleEndian = 0,
    bigEndian    
}E_DataEndian;
#endif

/* Exported functions --------------------------------------------------------*/

/* U32 Data Endian Swap */      
#define BigLittleSwap32(A)          ((((unsigned int)(A) & 0xFF000000) >> 24) | \
                                     (((unsigned int)(A) & 0x00FF0000) >> 8)  | \
                                     (((unsigned int)(A) & 0x0000FF00) << 8)  | \
                                     (((unsigned int)(A) & 0x000000FF) << 24)) 
/* UID Function pointer type */

typedef void (*ChipUIDAlgo_Typedef)(char pUserID[], char pChipID[], char pKey[]);															 
/**
  * @brief  Initialization chip ID. Called at initialization time
  * Note:   Please do not place ChipUIDAlgo_Calc in the same place as ChipUIDAlgo_Check
  * @retval void
  */																		 
void ChipUIDInitial(void);
/**
  * @brief  Calculate the key
  * Note:   Before calling. Must have called ChipUIDInitial      
  * @retval pKey
  */
																		 
char * ChipUIDAlgo_Calc(void);

/**
  * @brief  Check the key
  * Note:   Before calling. Must have called ChipUIDInitial      
  * @retval if key is same then retun true,Otherwise, return false
  */
bool ChipUIDAlgo_Check(void);


#ifdef __cplusplus
}
#endif

#endif /* CORTEX_CHIPID_BINDING_H */
